using System;
using Server;


namespace Server.Items
{
	public class BrazierBottom : Item
	{
		[Constructable]
		public BrazierBottom() : this( 1 )
		{
		}

		[Constructable]
		public BrazierBottom( int amount ) : base( 0x19BB )
		{
			Name = "A Braizer";
			Hue = 0x0;
			Stackable = false;
			Weight = 5.1;
			Amount = amount;
		}

		public BrazierBottom( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}
